#include "texManager.h"
#include "manager.h"
#include "modeGame.h"
#include "scene2D.h"
#include "input.h"
#include "renderer.h"

// -------- -------- -------- -------- -------- -------- -------- --------
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene2D::Init(void)
{
	// ϐ̏
	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));		// W
	SetSize(D3DXVECTOR3(1.f, 1.f, 1.f));		// TCY
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));		// ]
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));		// g嗦
	m_texUV = D3DXVECTOR2(0.f, 0.f);
	m_widthUV = 1.f;
	m_heightUV = 1.f;
}

// -------- -------- -------- -------- -------- -------- -------- --------
// _̍쐬
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene2D::CreateVtxBuffer(void)
{
	// g_D3Device̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	// _̍쐬
	if (FAILED(pDevice->CreateVertexBuffer(
		sizeof(VERTEX_2D) * NUM_VERTEX,		// ̃TCY
		D3DUSAGE_WRITEONLY,					// gp@(݂̂)
		FVF_VERTEX_2D,						// gp钸_tH[}bg(Ȃ)
		D3DPOOL_MANAGED,					// obt@̊Ǘ@(ɕĂ)
		&m_pVtxBuffer,						// 
		nullptr
	)))
	{
		assert(!"VtxBuffer̍쐬s");
	}
	// zAhX擾邽߂̕ϐ
	VERTEX_2D* pVtx;
	// obt@bNzAhX擾(0̏ꏊ0(S)bN)
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	// _W̐ݒ
	D3DXVECTOR3 pos = GetPos();
	D3DXVECTOR3 size = GetSize();
	D3DXVECTOR3 scl = GetScl();
	D3DXVECTOR3 rot = GetRot();
	float len = sqrt(size.x * size.x + size.y * size.y);
	float ang = atan2(size.y, size.x);
	pVtx[0].pos = D3DXVECTOR3(cosf(ang + D3DX_PI + rot.z) * len * scl.x + pos.x,
		sinf(ang + D3DX_PI + rot.z) * len * scl.y + pos.y, 0.f);
	pVtx[1].pos = D3DXVECTOR3(cosf(-ang + rot.z) * len * scl.x + pos.x,
		sinf(-ang + rot.z) * len * scl.y + pos.y, 0.f);
	pVtx[2].pos = D3DXVECTOR3(cosf(-ang + D3DX_PI + rot.z) * len * scl.x + pos.x,
		sinf(-ang + D3DX_PI + rot.z) * len * scl.y + pos.y, 0.f);
	pVtx[3].pos = D3DXVECTOR3(cosf(ang + rot.z) * len * scl.x + pos.x,
		sinf(ang + rot.z) * len * scl.y + pos.y, 0.f);
	// rhw̐ݒ
	pVtx[0].rhw = 1.f;
	pVtx[1].rhw = 1.f;
	pVtx[2].rhw = 1.f;
	pVtx[3].rhw = 1.f;
	// _F̐ݒ
	pVtx[0].col = D3DCOLOR_RGBA(255, 255, 255, 255);
	pVtx[1].col = D3DCOLOR_RGBA(255, 255, 255, 255);
	pVtx[2].col = D3DCOLOR_RGBA(255, 255, 255, 255);
	pVtx[3].col = D3DCOLOR_RGBA(255, 255, 255, 255);
	// UVW̐ݒ
	pVtx[0].tex = D3DXVECTOR2(0.f, 0.f);
	pVtx[1].tex = D3DXVECTOR2(1.f, 0.f);
	pVtx[2].tex = D3DXVECTOR2(0.f, 1.f);
	pVtx[3].tex = D3DXVECTOR2(1.f, 1.f);

	// ݒobt@̃AbN
	m_pVtxBuffer->Unlock();
}

// -------- -------- -------- -------- -------- -------- -------- --------
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene2D::Uninit(void)
{
	// vtxobt@̉
	if(m_pVtxBuffer != nullptr)
	{
		m_pVtxBuffer->Release();
		m_pVtxBuffer = nullptr;
	}
}

// -------- -------- -------- -------- -------- -------- -------- --------
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene2D::Update(void)
{
	// zAhX擾邽߂̕ϐ
	VERTEX_2D* pVtx;
	// obt@bNzAhX擾(0̏ꏊ0(S)bN)
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	D3DXVECTOR3 pos = GetPos();
	D3DXVECTOR3 size = GetSize();
	D3DXVECTOR3 scl = GetScl();
	D3DXVECTOR3 rot = GetRot();
	float len = sqrt(size.x * size.x + size.y * size.y);
	float ang = atan2(size.y, size.x);
	pVtx[0].pos = D3DXVECTOR3(cosf(ang + D3DX_PI + rot.z) * len * scl.x + pos.x,
		sinf(ang + D3DX_PI + rot.z) * len * scl.y + pos.y, 0.f);
	pVtx[1].pos = D3DXVECTOR3(cosf(-ang + rot.z) * len * scl.x + pos.x,
		sinf(-ang + rot.z) * len * scl.y + pos.y, 0.f);
	pVtx[2].pos = D3DXVECTOR3(cosf(-ang + D3DX_PI + rot.z) * len * scl.x + pos.x,
		sinf(-ang + D3DX_PI + rot.z) * len * scl.y + pos.y, 0.f);
	pVtx[3].pos = D3DXVECTOR3(cosf(ang + rot.z) * len * scl.x + pos.x,
		sinf(ang + rot.z) * len * scl.y + pos.y, 0.f);

	// UVW̐ݒ
	pVtx[0].tex = D3DXVECTOR2(m_texUV.x, m_texUV.y);
	pVtx[1].tex = D3DXVECTOR2(m_texUV.x + m_widthUV, m_texUV.y);
	pVtx[2].tex = D3DXVECTOR2(m_texUV.x, m_texUV.y + m_heightUV);
	pVtx[3].tex = D3DXVECTOR2(m_texUV.x + m_widthUV, m_texUV.y + m_heightUV);

	// _F̐ݒ
	pVtx[0].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
	pVtx[1].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
	pVtx[2].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);
	pVtx[3].col = D3DCOLOR_RGBA(m_r, m_g, m_b, m_a);

	// ݒobt@̃AbN
	m_pVtxBuffer->Unlock();
}

// -------- -------- -------- -------- -------- -------- -------- --------
// `
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene2D::Draw(void)
{
	// D3Device̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();
	
	// _obt@foCX̃f[^ Xg[ɃoCh
	pDevice->SetStreamSource(0, m_pVtxBuffer, 0, sizeof(VERTEX_2D));

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(m_strFilePass));

	// |S̕` // |Š`, [hŏ̒_̃CfbNX, |S
	pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON);
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CScene2D *CScene2D::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &size, const std::string &strFilePass, int priority)
{
	// CScene2D̐
	CScene2D *pScene2D;
	pScene2D = new CScene2D(priority);
	pScene2D->Init();

	pScene2D->SetPos(pos);
	pScene2D->SetRot(rot);
	pScene2D->SetSize(size);
	pScene2D->CreateVtxBuffer();
	pScene2D->m_strFilePass = strFilePass;
	
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(strFilePass);

	return pScene2D;
}

void CScene2D::SetTexturePos(D3DXVECTOR2 uv, D3DXVECTOR2 length)
{
	m_texUV = uv;
	m_heightUV = length.y;
	m_widthUV = length.x;
}